 ; Ŀ
 ;   Loca - load Personal.lsp from the directory containing acad.exe.      
 ;   Coax - load Corporate.lsp from the directory containing acad2.lsp.    
 ;                                                                         
 ;   These use the subroutine Locax which can do this for other files.     
 ;   This should be done at the end so as to overrid other settings.       
 ;   Copyright 2008, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ;   The idea here is that Personal and Corporate.lsp are used for         
 ;   stuff you don't want overwritten during an update.                    
 ;   Therefore neither file is included with Rocket - you have to make     
 ;   your own.  Local.lsp can be used as a prototype.                      
 ;                                                                         
 ;   Computers: increasingly personal.                                     
 ; 

 ; Ŀ
 ;   Spath - split a path and filename string into a path and a filename.  
 ; 
 (DEFUN SPATH (tt / pos pp)
 ; Ŀ
 ;   Set the pointer Pos to the end of the string.                         
 ; 
  (setq pos (strlen tt))                            ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq pp (substr tt 1 pos))      ; then set pp to all before
                   (setq tt (substr tt (1+ pos)))   ;          tt to all after
                   (setq pos 1)))                   ;      and pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 (list pp tt))
 ; Ŀ
 ;   Spath end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Locax: if can find a file, load another in the same dir.   
 ;   Arguments: Anchor, the file to find.                                  
 ;              Toad, the file to load.                                    
 ;   Calls nothing, returns t or nil.                                      
 ;   Both files must be in the Acad search path.                           
 ;   Note that this includes the current directory.                        
 ;   Extensions are required.                                              
 ; 
 (DEFUN LOCAX (anchor toad / filnam)
  (if (and (setq filnam (strcat (car (spath (findfile anchor))) toad))
           (setq filnam (findfile filnam)))
      (load filnam "fail"))
 (if fail nil t))
 ; Ŀ
 ;   Subroutine Locax end.                                                 
 ; 

 ; Ŀ
 ;   Coax.                                                                 
 ; 
 (DEFUN C:COAX (/ filnam)
 ; Ŀ
 ;   Find the file Corporate.lsp in c:\...\Rocket and load it.             
 ; 
  (locax "acad2.lsp" "Corporate.lsp")
 (princ))

 ; Ŀ
 ;   Loca.                                                                 
 ; 
 (DEFUN C:LOCA (/ filnam)
 ; Ŀ
 ;   Find the file Personal.lsp in c:\etc\acad and load it.                
 ; 
  (locax "acad.exe" "Personal.lsp")
 (princ))